/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.ntfy.eventchain.ChainedObject;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public class FilterList
extends DescriptiveObject
implements Serializable {
    static final long serialVersionUID = -1109091861987402042L;
    private static final String TRACE_MASKT = "XNTYFLST";
    private static final String TRACE_MASKF = "XNTYFLSF";
    private static final String TRACE_MASKD = "XNTYFLSD";
    private ArrayList _filters = new ArrayList();

    public FilterList() {
    }

    public FilterList(String name, String description) {
        super(name, description);
    }

    public boolean pass(EventObject event) {
        if (!super.pass(event)) {
            return false;
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (((ChainedObject)i.next()).pass(event)) continue;
            return false;
        }
        return true;
    }

    public List getFilters() {
        this.cleanup();
        return this._filters;
    }

    public Iterator iterator() {
        this.cleanup();
        return this._filters.iterator();
    }

    private void cleanup() {
        Iterator i = this._filters.iterator();
        ChainedObject obj = null;
        ChainedObject current = null;
        ArrayList<ChainedObject> additions = new ArrayList<ChainedObject>();
        while (i.hasNext()) {
            obj = (ChainedObject)i.next();
            if (obj == (current = obj.getCurrent())) continue;
            i.remove();
            if (current == null) continue;
            additions.add(current);
        }
        this._filters.addAll(additions);
    }

    public void deleteFilter(ChainedObject filter) {
        Trace.trace(TRACE_MASKT, "-> deleteFilter(" + ((DescriptiveObject)filter).getName() + ")");
        filter.setDeleted();
        this._filters.remove(this._filters.indexOf(filter));
        Trace.trace(TRACE_MASKT, "<- deleteFilter");
    }

    public void add(ChainedObject filter) {
        Trace.trace(TRACE_MASKT, "-> addFilter(" + ((DescriptiveObject)filter).getName() + ")");
        this._filters.add(filter);
        Trace.trace(TRACE_MASKT, "<- addFilter");
    }

    public ChainedObject get(int i) {
        this.cleanup();
        return (ChainedObject)this._filters.get(i);
    }

    public int size() {
        this.cleanup();
        return this._filters.size();
    }

    public String toString() {
        this.cleanup();
        StringBuffer buff = new StringBuffer();
        buff.append(this.getClass().getName());
        buff.append("[ ");
        if (this._filters != null) {
            Iterator i = this._filters.iterator();
            while (i.hasNext()) {
                buff.append(i.next().toString());
                if (!i.hasNext()) continue;
                buff.append(",\n");
            }
        }
        buff.append(" ]");
        return buff.toString();
    }
}

